% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{order_on_p}
\alias{order_on_p}
\alias{order_on_t}
\alias{order_on_effect}
\title{Order on p}
\usage{
order_on_p(
  object,
  fit = autonomics::fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  combiner = "|",
  decreasing = FALSE,
  verbose = TRUE
)

order_on_t(
  object,
  fit = autonomics::fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  combiner = "|",
  decreasing = FALSE,
  verbose = TRUE
)

order_on_effect(
  object,
  fit = autonomics::fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  combiner = "|",
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{string vector: subset of `fits(object)`}

\item{coefs}{string vector: subset of `coefs(object)`}

\item{combiner}{'|' or '&'}

\item{decreasing}{TRUE or FALSE}

\item{verbose}{TRUE or FALSE}
}
\value{
SummarizedExperiment
}
\description{
Order on p
}
\examples{
# Linmod
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    order_on_p(object)
    object \%<>\% fit_limma()
    order_on_p(object)
# Survival
    object <- survival_example()
    object \%<>\% fit_survival()
    order_on_p(object)
}
