% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_plot_volcano.R
\name{plot_coef_densities}
\alias{plot_coef_densities}
\title{Plot contrast densities}
\usage{
plot_coef_densities(
  object,
  fit = fits(object)[1],
  coefs = autonomics::coefs(object, fit = fit),
  sep = FITSEP,
  label = "feature_id"
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{'limma', 'lm', 'lme', 'lmer', or 'wilcoxon'}

\item{coefs}{character vector}

\item{sep}{string}

\item{label}{svar}
}
\value{
ggplot
}
\description{
Plot contrast densities
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% fit_limma(~subgroup, block = 'Subject')
plot_coef_densities(object)
}
