% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{plot_contrast_venn}
\alias{plot_contrast_venn}
\title{Plot contrast venn}
\usage{
plot_contrast_venn(issig, colors = NULL)
}
\arguments{
\item{issig}{matrix(nrow, ncontrast): -1 (down), +1 (up)}

\item{colors}{NULL or colorvector}
}
\value{
nothing returned
}
\description{
Plot contrast venn
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% fit_wilcoxon(~ subgroup, block = 'Subject')
object \%<>\% fit_limma(   ~ subgroup, block = 'Subject', codingfun = contr.treatment.explicit)
isfdr <- is_sig(object, contrast = 't3-t0', quantity = 'p', fit = fits(object))
plot_contrast_venn(isfdr)
}
