% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{plot_data}
\alias{plot_data}
\title{Plot data}
\usage{
plot_data(
  data,
  geom = geom_point,
  color = NULL,
  fill = NULL,
  linetype = NULL,
  ...,
  palette = NULL,
  fixed = list(),
  theme = list()
)
}
\arguments{
\item{data}{data.frame'}

\item{geom}{geom_point, etc.}

\item{color}{variable mapped to color (symbol)}

\item{fill}{variable mapped to fill (symbol)}

\item{linetype}{variable mapped to linetype (symbol)}

\item{...}{mapped aesthetics}

\item{palette}{color palette (named character vector)}

\item{fixed}{fixed  aesthetics (list)}

\item{theme}{list with ggplot theme specifications}
}
\value{
ggplot object
}
\description{
Plot data
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% pca()
data <- sdt(object)
plot_data(data, x = `t~sample_id~pca1`, y = `t~sample_id~pca2`)
plot_data(data, x = `t~sample_id~pca1`, y = `t~sample_id~pca2`, color = subgroup)
plot_data(data, x = `t~sample_id~pca1`, y = `t~sample_id~pca2`, color = NULL)
fixed <- list(shape = 15, size = 3)
plot_data(data, x = `t~sample_id~pca1`, y = `t~sample_id~pca2`, fixed = fixed)
}
\author{
Aditya Bhagwat, Johannes Graumann
}
