% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{plot_exprs}
\alias{plot_exprs}
\alias{plot_sample_boxplots}
\alias{plot_feature_boxplots}
\title{Plot exprs for coef}
\usage{
plot_exprs(
  object,
  dim = "both",
  assay = assayNames(object)[1],
  features = NULL,
  fit = fits(object)[1],
  coefs = autonomics::coefs(object, fit = fit),
  block = NULL,
  x = default_x(object, dim),
  geom = default_geom(object, x = x, block = block),
  color = x,
  fill = x,
  shape = NULL,
  size = NULL,
  alpha = NULL,
  linetype = NULL,
  highlight = NULL,
  combiner = "|",
  p = 1,
  fdr = 1,
  facet = if (dim == "both") "feature_id" else NULL,
  file = NULL,
  width = 7,
  height = 7,
  n = if (is.null(file)) 4 else 12,
  ncol = if (is.null(file)) NULL else 3,
  nrow = if (is.null(file)) NULL else 4,
  scales = "free_y",
  labeller = "label_value",
  pointsize = if (is.null(block)) 0 else 0.5,
  jitter = if (is.null(block)) 0.1 else 0,
  fillpalette = make_var_palette(object, fill),
  colorpalette = make_var_palette(object, color),
  hlevels = NULL,
  title = switch(dim, both = x, features = "Feature Boxplots", samples =
    "Sample Boxplots"),
  subtitle = if (!is.null(fit)) coefs else "",
  xlab = x,
  ylab = "value",
  theme = ggplot2::theme(plot.title = element_text(hjust = 0.5)),
  verbose = TRUE
)

plot_sample_boxplots(
  object,
  fill = if ("subgroup" \%in\% svars(object)) "subgroup" else "sample_id",
  n = min(ncol(object), 16),
  ...
)

plot_feature_boxplots(object, ...)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{dim}{'samples'   (per-sample distribution across features), \cr
'features' (per-feature distribution across samples ) or 
'both'        (subgroup distribution faceted per feature)}

\item{assay}{string: value in assayNames(object)}

\item{features}{features to plot no matter what (character vector)}

\item{fit}{'limma', 'lm', 'lme', 'lmer', 'wilcoxon'}

\item{coefs}{subset of coefs(object) to consider in selecting top}

\item{block}{group svar}

\item{x}{x svar}

\item{geom}{'boxplot' or 'point'}

\item{color}{color svar: points, lines}

\item{fill}{fill svar: boxplots}

\item{shape}{shape svar}

\item{size}{size svar}

\item{alpha}{alpha svar}

\item{linetype}{linetype svar}

\item{highlight}{highlight svar}

\item{combiner}{'&' or '|'}

\item{p}{fraction: p   cutoff}

\item{fdr}{fraction: fdr cutoff}

\item{facet}{string: fvar mapped to facet}

\item{file}{NULL or filepath}

\item{width}{inches}

\item{height}{inches}

\item{n}{number of samples (dim = 'samples') or features (dim = 'features' or 'both') to plot}

\item{ncol}{number of cols in faceted plot (if dim = 'both')}

\item{nrow}{number of rows in faceted plot (if dim = 'both)}

\item{scales}{'free_y', 'free'x', 'fixed'}

\item{labeller}{string or function}

\item{pointsize}{number}

\item{jitter}{jitter width (number)}

\item{fillpalette}{named character vector: fill palette}

\item{colorpalette}{named character vector: color palette}

\item{hlevels}{xlevels for which to plot hlines}

\item{title}{string}

\item{subtitle}{string}

\item{xlab}{string}

\item{ylab}{string}

\item{theme}{ggplot2::theme(...) or NULL}

\item{verbose}{TRUE or FALSE}

\item{...}{used to maintain depreceated functions}
}
\value{
ggplot object
}
\description{
Plot exprs for coef
}
\examples{
# Without limma
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    plot_exprs(object, block = 'Subject', title = 'Subgroup Boxplots')
    plot_exprs(object, dim = 'samples')
    plot_exprs(object, dim = 'features', block = 'sample_id')
# With limma 
    object \%<>\% fit_limma(block = 'Subject')
    plot_exprs(object, block = 'Subject')
    plot_exprs(object, block = 'Subject', coefs = c('t1-t0', 't2-t0', 't3-t0'))
    plot_exprs_per_coef(object, x = 'Time', block = 'Subject')
# Points
    plot_exprs(object, geom = 'point', block = 'Subject')
# Add highlights
    controlfeatures <- c('biotin','phosphate')
    fdt(object) \%<>\% cbind(control = .$feature_name \%in\% controlfeatures)
    plot_exprs(object, dim = 'samples', highlight = 'control')
# Multiple pages
    plot_exprs(object, block = 'Subject', n = 4, nrow = 1, ncol = 2)
}
\seealso{
\code{\link{plot_sample_densities}},
         \code{\link{plot_sample_violins}}
}
