% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{Plot heatmap}
\usage{
plot_heatmap(
  object,
  fit = fits(object)[1],
  coef = autonomics::coefs(object, fit = fit)[1],
  effectsize = 0,
  p = 1,
  fdr = 0.05,
  n = 100,
  assay = assayNames(object)[1],
  cluster_features = FALSE,
  cluster_samples = FALSE,
  flabel = intersect(c("gene", "feature_id"), fvars(object))[1],
  group = "subgroup",
  verbose = TRUE,
  title = NULL
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{'limma', 'lm', 'lme(r)', 'wilcoxon'}

\item{coef}{string: one of coefs(object)}

\item{effectsize}{number: effectsize filter}

\item{p}{number: p    filter}

\item{fdr}{number: fdr  filter}

\item{n}{number: n filter}

\item{assay}{string: one of assayNames(object)}

\item{cluster_features}{TRUE or FALSE}

\item{cluster_samples}{TRUE or FALSE}

\item{flabel}{string: feature label}

\item{group}{sample groupvar}

\item{verbose}{TRUE or FALSE}

\item{title}{string}
}
\description{
Plot heatmap
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file, fit = 'limma')
plot_heatmap(object)
}
