% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_plot.R
\name{plot_joint_density}
\alias{plot_joint_density}
\title{Plot joint density}
\usage{
plot_joint_density(
  object,
  xvar,
  yvar,
  color = TRUE,
  contour = TRUE,
  smooth = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{xvar}{svar}

\item{yvar}{svar}

\item{color}{TRUE or FALSE}

\item{contour}{TRUE or FALSE}

\item{smooth}{TRUE or FALSE}
}
\value{
ggplot
}
\description{
Plot joint density
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
set.seed(20)
object$Height <- rnorm(ncol(object), mean = 176)
object$Weight <- rnorm(ncol(object), mean = 85.4)
plot_joint_density(object, 'Height', 'Weight')
plot_joint_density(object, 'Height', 'Weight',  smooth = TRUE)
plot_joint_density(object, 'Height', 'Weight',   color = TRUE)
plot_joint_density(object, 'Height', 'Weight', contour = TRUE)
}
