% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_impute.R
\name{plot_detections}
\alias{plot_detections}
\alias{plot_summarized_detections}
\alias{plot_sample_nas}
\alias{plot_subgroup_nas}
\title{Plot missingness per sample / subgroup}
\usage{
plot_detections(...)

plot_summarized_detections(...)

plot_sample_nas(
  object,
  by = "subgroup",
  fill = by,
  palette = make_svar_palette(object, fill),
  axis.text.y = element_blank()
)

plot_subgroup_nas(
  object,
  by = "subgroup",
  fill = by,
  palette = NULL,
  na_imputes = TRUE
)
}
\arguments{
\item{...}{used to maintain deprecated functions}

\item{object}{SummarizedExperiment}

\item{by}{svar (string)}

\item{fill}{svar (string)}

\item{palette}{color vector (names = levels, values = colors)}

\item{axis.text.y}{passed to ggplot2::theme}

\item{na_imputes}{TRUE or FALSE}
}
\value{
ggplot object
}
\description{
\code{plot_sample_nas} shows systematic and random missingness 
(white), and full detection (bright color) at sample resolution.
Imputations are also shown (light color).
}
\details{
\code{plot_subgroup_nas} shows systematic missingness at subgroup resolution.
Random missingness and full detection are shown together (bright color).
Imputations are also shown (light color).
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
plot_sample_nas(object)
plot_sample_nas(impute(object))
plot_subgroup_nas(object)
plot_subgroup_nas(impute(object))

subgroups <- sprintf('\%s_STD', c('E00','E01','E02','E05','E15','E30','M00'))
file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file, subgroups = subgroups)
plot_subgroup_nas(object)
plot_subgroup_nas(object, 'subgroup')
plot_sample_nas(object)
plot_sample_nas(object, 'subgroup')
}
