% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_analyze.R
\name{plot_summary}
\alias{plot_summary}
\title{Plot summary}
\usage{
plot_summary(
  object,
  fit = "limma",
  formula = default_formula(object),
  block = NULL,
  label = "feature_id",
  palette = make_svar_palette(object, svar = svar)
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{linmod engine : 'limma', 'lm', 'lme', 'lmer' or 'wilcoxon'}

\item{formula}{model formula}

\item{block}{NULL or svar}

\item{label}{fvar}

\item{palette}{NULL or colorvector}
}
\description{
Plot summary
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% pca()
object \%<>\% pls(by = 'subgroup')
object \%<>\% fit_limma()
plot_summary(object, block = 'Subject')
}
