% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_survival.R
\name{plot_survival}
\alias{plot_survival}
\title{Plot survival}
\usage{
plot_survival(
  object,
  assay = assayNames(object)[1],
  engine = intersect(fits(object), c("coxph", "survdiff", "logrank")),
  ntile = 2,
  title = sprintf("surv ~ expr"),
  subtitle = sprintf("\%s", paste0(engine, collapse = "      ")),
  file = NULL,
  width = 7,
  height = 7,
  n = min(nrow(object), 9),
  ncol = 3,
  nrow = 3
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{assay}{value in assayNames(object)}

\item{engine}{'coxph', 'survdiff' or 'logrank'}

\item{ntile}{number of quantiles}

\item{title}{string}

\item{subtitle}{string}

\item{file}{filepath}

\item{width}{number}

\item{height}{number}

\item{n}{number of features to plot}

\item{ncol}{number of columns}

\item{nrow}{number of rows}
}
\value{
ggplot
}
\description{
Plot survival
}
\examples{
# Defaults
    object <- survival_example()
    object \%<>\% fit_survival()
    plot_survival(object)
# Engines
    object <- survival_example()
    object \%<>\% fit_survival(engine = c('coxph', 'survdiff', 'logrank'))
    plot_survival(object)
# Pdf
    # plot_survival(object, file = file.path('testdir', 'survival', 'survival.pdf'))
}
