% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{Plot volcano}
\usage{
plot_volcano(
  object,
  fit = fits(object)[1],
  coefs = autonomics::coefs(object, fit = fit)[1],
  facet = if (is_scalar(fit)) "coef" else c("fit", "coef"),
  scales = "fixed",
  shape = if ("imputed" \%in\% fvars(object)) "imputed" else NULL,
  size = NULL,
  alpha = NULL,
  label = "feature_id",
  max.overlaps = 10,
  features = NULL,
  nrow = length(fit),
  p = 0.05,
  fdr = 0.05,
  n = Inf,
  xndown = NULL,
  xnup = NULL,
  title = NULL,
  file = NULL,
  width = 7,
  height = 7,
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{'limma', 'lme', 'lm', 'wilcoxon'}

\item{coefs}{character vector}

\item{facet}{character vector}

\item{scales}{'free', 'fixed', etc.}

\item{shape}{fvar  (string)}

\item{size}{fvar  (string)}

\item{alpha}{fvar  (string)}

\item{label}{fvar  (string)}

\item{max.overlaps}{number: passed to ggrepel}

\item{features}{feature ids (character vector): features to encircle}

\item{nrow}{number: no of rows in plot}

\item{p}{number:   p cutoff for labeling}

\item{fdr}{number: fdr cutoff for labeling}

\item{n}{number:   n cutoff for labeling}

\item{xndown}{x position of ndown labels}

\item{xnup}{x position of nup labels}

\item{title}{string or NULL}

\item{file}{filename}

\item{width}{number}

\item{height}{number}

\item{verbose}{TRUE or FALSE}
}
\value{
ggplot object
}
\description{
Plot volcano
}
\examples{
# Regular Usage
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    object \%<>\% fit_limma()
    object \%<>\% fit_lm()
    plot_volcano(object, coefs = 't3-t0', fit = 'limma')                   # single contrast
    plot_volcano(object, coefs = c('t2-t0', 't3-t0'), fit = 'limma')          # multip contrasts
    plot_volcano(object, coefs = c('t2-t0', 't3-t0'), fit = c('limma', 'lm')) # multip contrs & methods

# When nothing passes FDR
    fdt(object) \%<>\% add_adjusted_pvalues('fdr', fit = 'limma',coefs = 't3-t0')
    object \%<>\% extract( fdrvec(object, fit = 'limma', coef = 't3-t0') > 0.05, )
    plot_volcano(object, coefs = 't3-t0', fit = 'limma')

# Additional mappings
    file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
    object <- read_maxquant_proteingroups(file, impute = TRUE)
    object \%<>\% fit_limma()
    plot_volcano(object)
    plot_volcano(object, label = 'gene')
    plot_volcano(object, label = 'gene', size = 'log2maxlfq')
    plot_volcano(object, label = 'gene', size = 'log2maxlfq', alpha = 'pepcounts')
    plot_volcano(object, label = 'gene', features = c('Q503D2_DANRE'))
    plot_volcano(object, label = 'gene', features = list(c('Q503D2_DANRE', 'Q6DGK4_DANRE'), 
                                                         c('Q6DGK4_DANRE', 'F1Q7L0_DANRE')))
}
