% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.1_read_rnaseq.R
\name{preprocess_rnaseq_counts}
\alias{preprocess_rnaseq_counts}
\title{Preprocess RNAseq counts}
\usage{
preprocess_rnaseq_counts(
  object,
  formula = ~subgroup,
  block = NULL,
  min_count = 10,
  pseudo = 0.5,
  tpm = FALSE,
  cpm = TRUE,
  voom = TRUE,
  log2 = TRUE,
  verbose = TRUE,
  plot = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{designmat formula}

\item{block}{blocK svar}

\item{min_count}{min count required in some samples}

\item{pseudo}{added pseudocount to avoid log(x)=-Inf}

\item{tpm}{TRUE or FALSE : tpm normalize?}

\item{cpm}{TRUE or FALSE : cpm normalize? (counts per million (scaled) reads)}

\item{voom}{TRUE or FALSE : voom weight?}

\item{log2}{TRUE or FALSE : log2 transform?}

\item{verbose}{TRUE or FALSE : msg?}

\item{plot}{TRUE or FALSE : plot?}
}
\value{
SummarizedExperiment
}
\description{
Preprocess RNAseq counts
}
\examples{
file <- system.file('extdata/billing19.rnacounts.txt', package = 'autonomics')
object <- .read_rnaseq_counts(file)
object$subgroup
object \%<>\% preprocess_rnaseq_counts()
}
