% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.7_read_metabolon.R
\name{.read_metabolon}
\alias{.read_metabolon}
\alias{read_metabolon}
\title{Read metabolon xlsxfile}
\usage{
.read_metabolon(
  file,
  sheet = "OrigScale",
  fidvar = "BIOCHEMICAL",
  sidvar = "(CLIENT_IDENTIFIER|Client ID)",
  sfile = NULL,
  by.x = "sample_id",
  by.y = NULL,
  groupvar = NULL,
  verbose = TRUE
)

read_metabolon(
  file,
  sheet = "OrigScale",
  fidvar = "BIOCHEMICAL",
  sidvar = "(CLIENT_IDENTIFIER|Client ID)",
  sfile = NULL,
  by.x = "sample_id",
  by.y = NULL,
  groupvar = NULL,
  fnamevar = "BIOCHEMICAL",
  kegg_pathways = FALSE,
  smiles = FALSE,
  impute = TRUE,
  plot = FALSE,
  pca = plot,
  pls = plot,
  label = "feature_id",
  fit = if (plot) "limma" else NULL,
  formula = as.formula("~ subgroup"),
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)
}
\arguments{
\item{file}{metabolon xlsx file}

\item{sheet}{excel sheet (number or string)}

\item{fidvar}{featureid var}

\item{sidvar}{samplid var}

\item{sfile}{sample file}

\item{by.x}{`file`  mergeby column}

\item{by.y}{`sfile` mergeby column}

\item{groupvar}{string}

\item{verbose}{TRUE or FALSE}

\item{fnamevar}{featurename fvar}

\item{kegg_pathways}{TRUE or FALSE: add kegg pathways?}

\item{smiles}{TRUE or FALSE: add smiles?}

\item{impute}{TRUE or FALSE: impute group-specific NA values?}

\item{plot}{TRUE or FALSE}

\item{pca}{TRUE or FALSE}

\item{pls}{TRUE or FALSE}

\item{label}{fvar}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)', 'wilcoxon' or NULL}

\item{formula}{model formula}

\item{block}{model blockvar: string or NULL}

\item{coefs}{model coefficients of interest:    character vector or NULL}

\item{contrasts}{coefficient contrasts of interest: character vector or NULL}

\item{palette}{NULL or colorvector}
}
\value{
SummarizedExperiment
}
\description{
Read metabolon xlsxfile
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
read_metabolon(file, plot = TRUE, block = 'Subject')
}
