% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.0_read_omics.R
\name{.read_rectangles}
\alias{.read_rectangles}
\alias{read_rectangles}
\title{Read omics data from rectangular file}
\usage{
.read_rectangles(
  file,
  sheet = 1,
  fid_rows,
  fid_cols,
  sid_rows,
  sid_cols,
  expr_rows,
  expr_cols,
  fvar_rows = NULL,
  fvar_cols = NULL,
  svar_rows = NULL,
  svar_cols = NULL,
  fdata_rows = NULL,
  fdata_cols = NULL,
  sdata_rows = NULL,
  sdata_cols = NULL,
  transpose = FALSE,
  verbose = TRUE
)

read_rectangles(
  file,
  sheet = 1,
  fid_rows,
  fid_cols,
  sid_rows,
  sid_cols,
  expr_rows,
  expr_cols,
  fvar_rows = NULL,
  fvar_cols = NULL,
  svar_rows = NULL,
  svar_cols = NULL,
  fdata_rows = NULL,
  fdata_cols = NULL,
  sdata_rows = NULL,
  sdata_cols = NULL,
  transpose = FALSE,
  sfile = NULL,
  sfileby = NULL,
  subgroupvar = character(0),
  verbose = TRUE
)
}
\arguments{
\item{file}{string: name of text (txt, csv, tsv, adat) or
excel (xls, xlsx) file}

\item{sheet}{integer/string: only relevant for excel files}

\item{fid_rows}{numeric vector: featureid rows}

\item{fid_cols}{numeric vector: featureid cols}

\item{sid_rows}{numeric vector: sampleid rows}

\item{sid_cols}{numeric vector: sampleid cols}

\item{expr_rows}{numeric vector: expr rows}

\item{expr_cols}{numeric vector: expr cols}

\item{fvar_rows}{numeric vector: fvar rows}

\item{fvar_cols}{numeric vector: fvar cols}

\item{svar_rows}{numeric vector: svar rows}

\item{svar_cols}{numeric vector: svar cols}

\item{fdata_rows}{numeric vector: fdata rows}

\item{fdata_cols}{numeric vector: fdata cols}

\item{sdata_rows}{numeric vector: sdata rows}

\item{sdata_cols}{numeric vector: sdata cols}

\item{transpose}{TRUE or FALSE (default)}

\item{verbose}{TRUE (default) or FALSE}

\item{sfile}{sample file}

\item{sfileby}{sample file mergeby column}

\item{subgroupvar}{subgroupvar in sfile}
}
\value{
SummarizedExperiment
}
\description{
Read omics data from rectangular file
}
\examples{
# RNASEQ
   file <- system.file('extdata/billing19.rnacounts.txt', package = 'autonomics')
   read_rectangles( file, fid_rows = 2:25,     fid_cols = 2,
                          sid_rows = 1,        sid_cols = 5:28,
                         expr_rows = 2:25 ,   expr_cols = 5:28,
                         fvar_rows = 1,       fvar_cols = 1:4,
                        fdata_rows = 2:25 ,  fdata_cols = 1:4,   transpose = FALSE)
# LCMSMS PROTEINGROUPS
   file <- system.file('extdata/billing19.proteingroups.txt', package = 'autonomics')
   read_rectangles(  file,
                     fid_rows = 2:21,    fid_cols = 383,
                     sid_rows = 1,       sid_cols = seq(124, 316, by = 6),
                    expr_rows = 2:21,   expr_cols = seq(124, 316, by = 6),
                    fvar_rows = 1,      fvar_cols = c(2, 6, 7, 383),
                   fdata_rows = 2:21,  fdata_cols = c(2, 6, 7, 383),
                   transpose  = FALSE )
# SOMASCAN
   file <- system.file('extdata/atkin.somascan.adat', package = 'autonomics')
   read_rectangles(file, fid_rows = 30,         fid_cols = 23:42,
                         sid_rows = 42:108,     sid_cols = 4,
                        expr_rows = 42:108,    expr_cols = 23:42,
                        fvar_rows = 28:40,     fvar_cols = 22,
                        svar_rows = 41,        svar_cols = 1:21,
                       fdata_rows = 28:40,    fdata_cols = 23:42,
                       sdata_rows = 42:108,   sdata_cols = 1:21,  transpose  = TRUE)
# METABOLON
   file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
   read_rectangles(file, sheet = 2,
                     fid_rows = 11:30,     fid_cols = 2,
                     sid_rows = 4,         sid_cols = 15:81,
                    expr_rows = 11:30,    expr_cols = 15:81,
                    fvar_rows = 10,       fvar_cols = 1:14,
                    svar_rows = 1:10,     svar_cols = 14,
                   fdata_rows = 11:30,   fdata_cols = 1:14,
                   sdata_rows = 1:10,    sdata_cols = 15:81,
                    transpose = FALSE )
}
