% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.6_read_somascan.R
\name{.read_somascan}
\alias{.read_somascan}
\alias{read_somascan}
\title{Read somascan adatfile}
\usage{
.read_somascan(
  file,
  fidvar = "Target",
  sidvar = "SampleId",
  sfile = NULL,
  by.x = NULL,
  by.y = NULL,
  groupvar = "SampleGroup",
  verbose = TRUE
)

read_somascan(
  file,
  fidvar = "Target",
  sidvar = "SampleId",
  sfile = NULL,
  by.x = NULL,
  by.y = NULL,
  groupvar = "SampleGroup",
  fname_var = "EntrezGeneSymbol",
  sample_type = "Sample",
  feature_type = "Protein",
  sample_quality = c("FLAG", "PASS"),
  feature_quality = c("FLAG", "PASS"),
  rm_na_svars = FALSE,
  rm_single_value_svars = FALSE,
  plot = FALSE,
  label = "feature_id",
  pca = plot,
  pls = plot,
  fit = if (plot) "limma" else NULL,
  formula = as.formula(sprintf("~ \%s", groupvar)),
  block = NULL,
  coefs = NULL,
  contrasts = NULL,
  palette = NULL,
  verbose = TRUE
)
}
\arguments{
\item{file}{somascan (adat) file}

\item{fidvar}{featureid var}

\item{sidvar}{sampleid  var}

\item{sfile}{sample file}

\item{by.x}{`file`  mergeby column}

\item{by.y}{`sfile` mergeby column}

\item{groupvar}{string}

\item{verbose}{TRUE or FALSE: message?}

\item{fname_var}{featurename var: string}

\item{sample_type}{subset of c('Sample','QC','Buffer','Calibrator')}

\item{feature_type}{subset of c('Protein', 'Hybridization Control Elution','Rat Protein')}

\item{sample_quality}{subset of c('PASS', 'FLAG', 'FAIL')}

\item{feature_quality}{subset of c('PASS', 'FLAG', 'FAIL')}

\item{rm_na_svars}{TRUE or FALSE: rm NA svars?}

\item{rm_single_value_svars}{TRUE or FALSE: rm single value svars?}

\item{plot}{TRUE or FALSE: plot ?}

\item{label}{fvar}

\item{pca}{TRUE or FALSE: run pca?}

\item{pls}{TRUE or FALSE: run pls?}

\item{fit}{model engine: 'limma', 'lm', 'lme(r)','wilcoxon' or NULL}

\item{formula}{model formula}

\item{block}{model blockvar}

\item{coefs}{model coefficients    of interest: character vector or NULL}

\item{contrasts}{coefficient contrasts of interest: character vector or NULL}

\item{palette}{character vector or NULL}
}
\value{
Summarizedexperiment
}
\description{
Read somascan adatfile
}
\examples{
file <- system.file('extdata/atkin.somascan.adat', package = 'autonomics')
read_somascan(file, plot = TRUE, block = 'Subject')
}
