% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit_limma.R
\name{reset_fit}
\alias{reset_fit}
\title{Reset fit}
\usage{
reset_fit(
  object,
  fit = fits(object),
  coefs = autonomics::coefs(object, fit = fit),
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{fit}{character vector}

\item{coefs}{character vector}

\item{verbose}{TRUE or FALSE}
}
\description{
Reset fit
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
(object <- read_metabolon(file))
object \%<>\% reset_fit()
object \%<>\% fit_limma() \%>\% reset_fit()
object \%<>\% fit_limma() \%>\% fit_lm() \%>\% reset_fit()
object \%<>\% fit_limma() \%>\% fit_lm() \%>\% reset_fit('limma')
}
