% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6_transform.R
\name{rm_unmatched_samples}
\alias{rm_unmatched_samples}
\alias{rm_singleton_samples}
\title{rm unmatched/singleton samples}
\usage{
rm_unmatched_samples(
  object,
  subgroupvar = "subgroup",
  subgroupctr = slevels(object, subgroupvar)[1],
  block,
  verbose = TRUE
)

rm_singleton_samples(object, subgroupvar = "subgroup", verbose = TRUE)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{subgroupvar}{subgroup variable (string)}

\item{subgroupctr}{control subgroup (string)}

\item{block}{block variable (string)}

\item{verbose}{TRUE/FALSE}
}
\value{
SummarizedExperiment
}
\description{
rm unmatched/singleton samples
}
\examples{
file <- system.file('extdata/atkin.somascan.adat', package = 'autonomics')
object <- read_somascan(file)
object \%<>\% filter_samples(subgroup \%in\% c('t1', 't2'), verbose = TRUE)
rm_singleton_samples(object, subgroupvar = 'Subject')
rm_unmatched_samples(object, subgroupvar = 'subgroup', block = 'Subject')
}
