% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_fit.R
\name{nfactors}
\alias{nfactors}
\alias{split_extract_fixed}
\alias{split_extract_regex}
\alias{split_extract}
\title{stri_split and extract}
\usage{
nfactors(x, sep = guess_sep(x))

split_extract_fixed(x, sep, i)

split_extract_regex(x, sep, i)

split_extract(x, i, sep = guess_sep(x))
}
\arguments{
\item{x}{character vector}

\item{sep}{string}

\item{i}{integer}
}
\value{
character vector
}
\description{
stri_split and extract
}
\examples{
# Read
    file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
    object <- read_metabolon(file)
    x <- object$sample_id[1:5]
    nfactors(x)
# Split
    split_extract_fixed(x, '.', 1:2)
    split_extract_fixed(x, '.', seq_len(nfactors(x)-1))
    split_extract_fixed(x, '.', nfactors(x))
    split_extract_fixed(fdt(object)$PUBCHEM, ';', 1) # with NA values
}
