% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/8_plot_volcano.R
\name{stri_detect_fixed_in_collapsed}
\alias{stri_detect_fixed_in_collapsed}
\title{Detect fixed patterns in collapsed strings}
\usage{
stri_detect_fixed_in_collapsed(x, patterns, sep)
}
\arguments{
\item{x}{vector with collapsed strings}

\item{patterns}{vector with fixed patterns (strings)}

\item{sep}{collapse separator (string) or NULL (if uncollapsed)}
}
\value{
boolean vector
}
\description{
Detect fixed patterns in collapsed strings
}
\examples{
file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
object <- read_maxquant_proteingroups(file)
x <- fdt(object)$uniprot
patterns <- c('A0A0R4IKT8', 'Q7T3G6')
table(stri_detect_fixed_in_collapsed(x = x, patterns = patterns, sep = ';'))
}
