% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_sumexp_to_dt.R
\name{sumexp_to_widedt}
\alias{sumexp_to_widedt}
\alias{sumexp_to_longdt}
\alias{sumexp_to_subrep_dt}
\title{SummarizedExperiment to data.table}
\usage{
sumexp_to_widedt(
  object,
  fvars = autonomics::fvars(object),
  assay = assayNames(object)[1]
)

sumexp_to_longdt(
  object,
  fvars = intersect("feature_name", autonomics::fvars(object)),
  svars = intersect("subgroup", autonomics::svars(object)),
  assay = assayNames(object) \%>\% intersect(c(.[1], "is_imputed"))
)

sumexp_to_subrep_dt(object, subgroup = subgroup)
}
\arguments{
\item{object}{sumexp}

\item{fvars}{additional fvars to include in table}

\item{assay}{matrix in assays(object) to be used}

\item{svars}{additional svars to include in table}

\item{subgroup}{subgroup (sym)}
}
\value{
data.table
}
\description{
SummarizedExperiment to data.table
}
\details{
\itemize{
   \item \code{sumexp_to_widedt}:    feature          x sample
   \item \code{sumexp_to_subrep_dt}: feature.subgroup x replicate
   \item \code{sumexp_to_longdt}:    feature.sample
}
}
\examples{
# Atkin Hypoglycemia
   file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
   object <- read_metabolon(file)
   sumexp_to_widedt(object)
   sumexp_to_longdt(object)
   sumexp_to_subrep_dt(object)

# Fukuda
   file <- system.file('extdata/fukuda20.proteingroups.txt', package = 'autonomics')
   object <- read_maxquant_proteingroups(file)
   values(object)
   fdt(object)
   object \%<>\% impute()
   table(fdt(object)$imputed)
   sumexp_to_longdt(object)
   sumexp_to_widedt(object)
   sumexp_to_longdt(object)
}
