% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_filter.R
\name{tag_features}
\alias{tag_features}
\title{Tag features}
\usage{
tag_features(
  object,
  keyvar,
  sep,
  features,
  tagvar = get_name_in_parent(features),
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{keyvar}{string : intersection fvar}

\item{sep}{string : keyvar collapse separator}

\item{features}{character vector : intersection set}

\item{tagvar}{string :}

\item{verbose}{TRUE or FALSE}
}
\value{
SummarizedExperiment
}
\description{
Tag features
}
\examples{
file <- system.file('extdata/atkin.somascan.adat', package = 'autonomics')
object <- read_somascan(file)
features <- AnnotationDbi::keys(org.Hs.eg.db::org.Hs.eg.db, keytype = 'SYMBOL')
object \%<>\% tag_features(keyvar = 'EntrezGeneSymbol', sep = ' ', features)
table(fdt(object)$features)
}
