% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_read_annotations.R
\name{uncollapse}
\alias{uncollapse}
\alias{recollapse}
\title{Uncollapse/Recollapse}
\usage{
uncollapse(dt, ..., sep = ";")

recollapse(dt, by, sep = ";")
}
\arguments{
\item{dt}{data.table}

\item{...}{cols}

\item{sep}{string}

\item{by}{string}
}
\description{
Uncollapse data.table cols
}
\examples{
# Example data
   (dt <- data.table::data.table(
              uniprot  = 'Q9BQL6;Q96AC1;Q96AC1-3', 
              protein  = 'FERM1_HUMAN;FERM2_HUMAN', 
              gene     = 'FERMT1;FERMT2', 
              family   = 'FERM'))
# Uncollapse
    uncollapse(dt, protein, gene, sep = ';')
    recollapse( uncollapse(dt, protein, gene, sep = ';'), by = 'uniprot')
    
# Unchanged when no sep
    uncollapse(dt, family, sep = ';')
    uncollapse(dt, family, sep = 'NOSEP')
}
