% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_sumexp_to_dt.R
\name{write_xl}
\alias{write_xl}
\alias{write_ods}
\title{Write xl/ods}
\usage{
write_xl(
  object,
  xlfile,
  fitcoefs = autonomics::fitcoefs(object),
  verbose = TRUE
)

write_ods(
  object,
  odsfile,
  fitcoefs = autonomics::fitcoefs(object),
  verbose = TRUE
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{xlfile}{file}

\item{fitcoefs}{character vector}

\item{verbose}{TRUE or FALSE}

\item{odsfile}{file}
}
\value{
filepath
}
\description{
Write xl/ods
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file, fit = 'limma')
xlfile  <- file.path(tempdir(), 'fukuda20.proteingroups.fdt.xlsx')
odsfile <- file.path(tempdir(), 'fukuda20.proteingroups.fdt.ods')
# write_xl(object,  xlfile)
# write_ods(object, odsfile)
}
