% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{estimates}
\alias{estimates}
\alias{estimates,Bacon-method}
\title{Method to extract the estimated parameters from the 'bacon'-object}
\usage{
estimates(object)

\S4method{estimates}{Bacon}(object)
}
\arguments{
\item{object}{'bacon'-object}
}
\value{
vector or matrix of estimates
}
\description{
Method to extract the estimated parameters from the 'bacon'-object
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
##nbins = 100 to speed up the calculations
bc <- bacon(y, nbins=100)
estimates(bc)
}
\seealso{
\code{\link{bacon}}
}
