% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{traces}
\alias{traces}
\alias{traces,Bacon-method}
\title{Method to plot Gibbs sampling traces}
\usage{
traces(object, burnin = TRUE, index = 1)

\S4method{traces}{Bacon}(object, burnin = TRUE, index = 1)
}
\arguments{
\item{object}{'bacon'-object}

\item{burnin}{include burnin period default true}

\item{index}{if multiple sets of test-statsistics where provided}
}
\value{
plot of the Gibbs Sampler traces
}
\description{
Method to plot Gibbs sampling traces
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
##nbins = 100 to speed up the calculations
bc <- bacon(y, nbins=100)
traces(bc)
}
\seealso{
\code{\link{bacon}}
}
