% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaconClass.R, R/BaconMethods.R
\name{tstat}
\alias{tstat}
\alias{tstat,Bacon-method}
\title{Method to extract inflation- and bias-corrected test-statistics}
\usage{
tstat(object, corrected = TRUE)

\S4method{tstat}{Bacon}(object, corrected = TRUE)
}
\arguments{
\item{object}{'bacon'-object}

\item{corrected}{optional return uncorrected}
}
\value{
vector or matrix of test-statistics
}
\description{
Method to extract inflation- and bias-corrected test-statistics
}
\examples{
y <- rnormmix(2000, c(0.9, 0, 1, 0, 4, 1))
##nbins = 100 to speed up the calculations
bc <- bacon(y, nbins=100)
head(tstat(bc))
}
\seealso{
\code{\link{bacon}}
}
