% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_DESeq2.R
\name{DA_DESeq2}
\alias{DA_DESeq2}
\title{DA_DESeq2}
\usage{
DA_DESeq2(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  design = NULL,
  contrast = NULL,
  alpha = 0.05,
  norm = c("ratio", "poscounts", "iterate"),
  weights,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{design}{character or formula to specify the model matrix.}

\item{contrast}{character vector with exactly three elements: the name of a
factor in the design formula, the name of the numerator level for the fold
change, and the name of the denominator level for the fold change.}

\item{alpha}{the significance cutoff used for optimizing the independent
filtering (by default 0.05). If the adjusted p-value cutoff (FDR) will be a
value other than 0.05, alpha should be set to that value.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose between the native DESeq2 normalization methods, 
such as \code{ratio}, \code{poscounts}, or \code{iterate}. Alternatively 
(only for advanced users), if \code{norm} is equal to "TMM", "TMMwsp", 
"RLE", "upperquartile", "posupperquartile", or "none" from 
\code{\link{norm_edgeR}}, "CSS" from \code{\link{norm_CSS}}, or "TSS" from 
\code{\link{norm_TSS}}, the normalization factors are automatically 
transformed into size factors. If custom factors are supplied, make sure 
they are compatible with DESeq2 size factors.}

\item{weights}{an optional numeric matrix giving observational weights.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
the dispersion estimates `dispEsts`, the matrix of summary statistics for
each tag `statInfo`, and a suggested `name` of the final object considering
the parameters passed to the function.
}
\description{
Fast run for DESeq2 differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Calculate the poscounts size factors
ps_NF <- norm_DESeq2(object = ps, method = "poscounts")
# The phyloseq object now contains the size factors:
sizeFacts <- phyloseq::sample_data(ps_NF)[, "NF.poscounts"]
head(sizeFacts)
# Differential abundance
DA_DESeq2(object = ps_NF, pseudo_count = FALSE, design = ~ group, contrast =
    c("group", "B", "A"), norm = "poscounts")
}
\seealso{
\code{\link[phyloseq]{phyloseq_to_deseq2}} for phyloseq to DESeq2
object conversion, \code{\link[DESeq2]{DESeq}} and
\code{\link[DESeq2]{results}} for the differential abundance method.
}
