% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_NOISeq.R
\name{DA_NOISeq}
\alias{DA_NOISeq}
\title{DA_NOISeq}
\usage{
DA_NOISeq(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  contrast = NULL,
  norm = c("rpkm", "uqua", "tmm", "n"),
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose between the native edgeR normalization methods, 
such as \code{TMM}, \code{TMMwsp}, \code{RLE}, \code{upperquartile}, 
\code{posupperquartile}, or \code{none}. Alternatively (only for advanced 
users), if \code{norm} is equal to "ratio", "poscounts", or "iterate" from 
\code{\link{norm_DESeq2}}, "CSS" from \code{\link{norm_CSS}}, or "TSS" from 
\code{\link{norm_TSS}}, the scaling factors are automatically transformed 
into normalization factors. If custom factors are supplied, make sure they 
are compatible with edgeR normalization factors.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function. NOISeq does not produce p-values but an estimated probability of 
differential expression for each feature. Note that these probabilities are 
not equivalent to p-values. The higher the probability, the more likely that 
the difference in abundance is due to the change in the experimental 
condition and not to chance... Hence, `pValMat` matrix is filled with 
\code{1 - prob} values which can be interpreted as 1 - FDR. Where FDR can 
be considered as an adjusted p-value (see NOISeq vignette).
}
\description{
Fast run for NOISeqBIO differential abundance detection method. It computes 
differential expression between two experimental conditions.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_NOISeq(object = ps, pseudo_count = FALSE, contrast = c("group", "B", "A"),
    norm = "tmm", verbose = FALSE)
}
\seealso{
\code{\link[NOISeq]{noiseqbio}} for analysis of differential 
expression/abundance between two experimental conditions from read count 
data.
}
