% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_Seurat.R
\name{DA_Seurat}
\alias{DA_Seurat}
\title{DA_Seurat}
\usage{
DA_Seurat(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  norm = "LogNormalize",
  scale.factor = 10000,
  test = "wilcox",
  contrast = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{norm}{Method for normalization. 
\describe{\item{\code{LogNormalize}}{ Feature counts for each sample are 
divided by the total counts of that sample and multiplied by the 
scale.factor. This is then natural-log transformed using log1p;}
\item{\code{CLR}}{ Applies a centered log ratio transformation;}
\item{\code{RC}}{ Relative counts. Feature counts for each sample are 
divided by the total counts of that sample and multiplied by the 
scale.factor. No log-transformation is applied. For counts per million 
(CPM) set scale.factor = 1e6;}
\item{\code{none}}{ No normalization}}}

\item{scale.factor}{Sets the scale factor for cell-level normalization}

\item{test}{Denotes which test to use. Available options are:
\describe{\item{\code{"wilcox"}}{ Identifies differentially abundant 
features between two groups of samples using a Wilcoxon Rank Sum test 
(default).}
\item{\code{"bimod"}}{ Likelihood-ratio test for the feature abundances, 
(McDavid et al., Bioinformatics, 2013).}
\item{\code{"roc"}}{ Identifies 'markers' of feature abundance using ROC 
analysis. For each feature, evaluates (using AUC) a classifier built on that 
feature alone, to classify between two groups of cells. An AUC value of 1 
means that abundance values for this feature alone can perfectly classify the
two groupings (i.e. Each of the samples in group.1 exhibit a higher level 
than each of the samples in group.2). An AUC value of 0 also means there is 
perfect classification, but in the other direction. A value of 0.5 implies 
that the feature has no predictive power to classify the two groups. Returns 
a 'predictive power' (abs(AUC-0.5) * 2) ranked matrix of putative 
differentially expressed genes.}
\item{\code{"t"}}{ Identify differentially abundant features between two 
groups of samples using the Student's t-test.}
\item{\code{"negbinom"}}{ Identifies differentially abundant features 
between two groups of samples using a negative binomial generalized linear 
model.}
\item{\code{"poisson"}}{ Identifies differentially abundant features between 
two groups of samples using a poisson generalized linear model.}
\item{\code{"LR"}}{ Uses a logistic regression framework to determine 
differentially abundant features. Constructs a logistic regression model 
predicting group membership based on each feature individually and compares 
this to a null model with a likelihood ratio test.}
\item{\code{"MAST"}}{ Identifies differentially expressed genes between two 
groups of cells using a hurdle model tailored to scRNA-seq data. Utilizes 
the MAST package to run the DE testing.}
\item{\code{"DESeq2"}}{ Identifies differentially abundant features between 
two groups of samples based on a model using DESeq2 which uses a negative 
binomial distribution (Love et al, Genome Biology, 2014).}}}

\item{contrast}{character vector with exactly three elements: the name of a
factor in the design formula, the name of the numerator level for the fold
change, and the name of the denominator level for the fold change.}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`, the 
matrix of summary statistics for each tag `statInfo`, and a suggested `name` 
of the final object considering the parameters passed to the function.
}
\description{
Fast run for Seurat differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
                         
# Differential abundance
DA_Seurat(object = ps, contrast = c("group","B","A"))

# Perform a simple Wilcoxon test using Seurat on raw data
DA_Seurat(object = ps, contrast = c("group","B","A"), norm = "none", 
    test = "wilcox")
}
\seealso{
\code{\link[Seurat]{CreateSeuratObject}} to create the Seurat
object, \code{\link[Seurat]{AddMetaData}} to add metadata information,
\code{\link[Seurat]{NormalizeData}} to compute the normalization for the
counts, \code{\link[Seurat]{FindVariableFeatures}} to estimate the
mean-variance trend, \code{\link[Seurat]{ScaleData}} to scale and center
features in the dataset, and \code{\link[Seurat]{FindMarkers}} to perform
differential abundance analysis.
}
