% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_metagenomeSeq.R
\name{DA_metagenomeSeq}
\alias{DA_metagenomeSeq}
\title{DA_metagenomeSeq}
\usage{
DA_metagenomeSeq(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  design = NULL,
  coef = 2,
  norm = "CSS",
  model = "fitFeatureModel",
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{design}{the model for the count distribution. Can be the variable name,
or a character similar to "~ 1 + group", or a formula.}

\item{coef}{coefficient of interest to grab log fold-changes.}

\item{norm}{name of the normalization method to use in the differential 
abundance analysis. Choose the native metagenomeSeq normalization method 
\code{CSS}. Alternatively (only for advanced users), if \code{norm} is equal 
to "TMM", "TMMwsp", "RLE", "upperquartile", "posupperquartile", or "none" 
from \code{\link{norm_edgeR}}, "ratio", "poscounts", or "iterate" from 
\code{\link{norm_DESeq2}}, or "TSS" from \code{\link{norm_TSS}}, the 
factors are automatically transformed into scaling factors. If custom 
factors are supplied, make sure they are compatible with metagenomeSeq 
normalization factors.}

\item{model}{character equal to "fitFeatureModel" for differential abundance 
analysis using a zero-inflated log-normal model, "fitZig" for a complex 
mathematical optimization routine to estimate probabilities that a zero for 
a particular feature in a sample is a technical zero or not. The latter model
relies heavily on the limma package (default 
\code{model = "fitFeatureModel"}).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`, the matrix
of summary statistics for each tag `statInfo`, and a suggested `name` of the
final object considering the parameters passed to the function.
}
\description{
Fast run for the metagenomeSeq's differential abundance detection method.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Calculate the CSS normalization factors
ps_NF <- norm_CSS(object = ps, method = "CSS")
# The phyloseq object now contains the normalization factors:
normFacts <- phyloseq::sample_data(ps_NF)[, "NF.CSS"]
head(normFacts)
# Differential abundance
DA_metagenomeSeq(object = ps_NF, pseudo_count = FALSE, design = ~ group,
    coef = 2, norm = "CSS")
}
\seealso{
\code{\link[metagenomeSeq]{fitZig}} for the Zero-Inflated Gaussian
regression model estimation and \code{\link[metagenomeSeq]{MRfulltable}}
for results extraction.
}
