% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{createEnrichment}
\alias{createEnrichment}
\title{createEnrichment}
\usage{
createEnrichment(
  object,
  priorKnowledge,
  enrichmentCol,
  namesCol = NULL,
  slot = "pValMat",
  colName = "adjP",
  type = "pvalue",
  direction = NULL,
  threshold_pvalue = 1,
  threshold_logfc = 0,
  top = NULL,
  alternative = "greater",
  verbose = FALSE
)
}
\arguments{
\item{object}{Output of differential abundance detection methods.
\code{pValMat}, \code{statInfo} matrices, and method's \code{name} must be
present (See vignette for detailed information).}

\item{priorKnowledge}{\code{data.frame} (with feature names as
\code{row.names}) containing feature level metadata.}

\item{enrichmentCol}{name of the column containing information for enrichment
analysis.}

\item{namesCol}{name of the column containing new names for features (default
\code{namesCol = NULL}).}

\item{slot}{A character vector with 1 or number-of-methods-times repeats of
the slot names where to extract values for each method
(default \code{slot = "pValMat"}).}

\item{colName}{A character vector with 1 or number-of-methods-times repeats
of the column name of the slot where to extract values for each method
(default \code{colName = "rawP"}).}

\item{type}{A character vector with 1 or number-of-methods-times repeats
of the value type of the column selected where to extract values for each
method. Two values are possible: \code{"pvalue"} or \code{"logfc"}
(default \code{type = "pvalue"}).}

\item{direction}{A character vector with 1 or number-of-methods-times repeats
of the \code{statInfo}'s column name containing information about the signs
of differential abundance (usually log fold changes) for each method
(default \code{direction = NULL}).}

\item{threshold_pvalue}{A single or a numeric vector of thresholds for
p-values. If present, features with p-values lower than
\code{threshold_pvalue} are considered differentially abundant. Set
\code{threshold_pvalue = 1} to not filter by p-values.}

\item{threshold_logfc}{A single or a numeric vector of thresholds for log
fold changes. If present, features with log fold change absolute values
higher than \code{threshold_logfc} are considered differentially abundant.
Set \code{threshold_logfc = 0} to not filter by log fold change values.}

\item{top}{If not null, the \code{top} number of features, ordered by
p-values or log fold change values, are considered as differentially
abundant (default \code{top = NULL}).}

\item{alternative}{indicates the alternative hypothesis and must be
    one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.
    You can specify just the initial letter.  Only used in the
    \eqn{2 \times 2}{2 by 2} case.}

\item{verbose}{Boolean to display the kind of extracted values
(default \code{verbose = FALSE}).}
}
\value{
a list of objects for each method. Each list contains:
\describe{
    \item{\code{data}}{ a \code{data.frame} object with DA directions,
    statistics, and feature names;}
    \item{\code{tables}}{ a list of 2x2 contingency tables;}
    \item{\code{tests}}{ the list of Fisher exact tests' p-values for each
    contingency table;}
    \item{\code{summaries}}{ a list with the first element of each
    contingency table and its p-value (for graphical purposes);}}
}
\description{
Create a \code{data.frame} object with several information to perform
enrichment analysis.
}
\examples{
data("ps_plaque_16S")
data("microbial_metabolism")

# Extract genera from the phyloseq tax_table slot
genera <- phyloseq::tax_table(ps_plaque_16S)[, "GENUS"]
# Genera as rownames of microbial_metabolism data.frame
rownames(microbial_metabolism) <- microbial_metabolism$Genus
# Match OTUs to their metabolism
priorInfo <- data.frame(genera,
    "Type" =  microbial_metabolism[genera, "Type"])
# Unmatched genera becomes "Unknown"
unknown_metabolism <- is.na(priorInfo$Type)
priorInfo[unknown_metabolism, "Type"] <- "Unknown"
priorInfo$Type <- factor(priorInfo$Type)
# Add a more informative names column
priorInfo[, "newNames"] <- paste0(rownames(priorInfo), priorInfo[, "GENUS"])

# Add some normalization/scaling factors to the phyloseq object
my_norm <- setNormalizations(fun = c("norm_edgeR", "norm_CSS"),
    method = c("TMM", "CSS"))
ps_plaque_16S <- runNormalizations(normalization_list = my_norm,
    object = ps_plaque_16S)

# Initialize some limma based methods
my_limma <- set_limma(design = ~ 1 + RSID + HMP_BODY_SUBSITE, 
    coef = "HMP_BODY_SUBSITESupragingival Plaque",
    norm = c("TMM", "CSS"))
    
# Make sure the subject ID variable is a factor
phyloseq::sample_data(ps_plaque_16S)[, "RSID"] <- as.factor(
    phyloseq::sample_data(ps_plaque_16S)[["RSID"]])

# Perform DA analysis
Plaque_16S_DA <- runDA(method_list = my_limma, object = ps_plaque_16S)

# Enrichment analysis
enrichment <- createEnrichment(object = Plaque_16S_DA,
    priorKnowledge = priorInfo, enrichmentCol = "Type", namesCol = "GENUS",
    slot = "pValMat", colName = "adjP", type = "pvalue", direction = "logFC",
    threshold_pvalue = 0.1, threshold_logfc = 1, top = 10, verbose = TRUE)
}
\seealso{
\code{\link{addKnowledge}}, \code{\link{extractDA}}, and
\code{\link{enrichmentTest}}.
}
