% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDistribution.R
\name{fitZINB}
\alias{fitZINB}
\title{fitZINB}
\usage{
fitZINB(object, assay_name = "counts", verbose = TRUE)
}
\arguments{
\item{object}{a phyloseq object, a TreeSummarizedExperiment object, or a 
matrix of counts.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{verbose}{an optional logical value. If \code{TRUE} information on the
steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A data frame containing the continuity corrected logarithms of the
average fitted values for each row of the matrix of counts in the \code{Y}
column, and the estimated probability to observe a zero in the \code{Y0}
column.
}
\description{
Fit a Zero-Inflated Negative Binomial (ZINB) distribution for each taxon of
the countdata. The ZINB estimation procedure is performed by zinbwave
\code{\link[zinbwave]{zinbFit}} function with \code{commondispersion = FALSE},
regularization parameter \code{epsilon = 1e10}, and not assuming the presence
of any group in the samples (design matrix equal to a column of ones.)
}
\examples{
# Generate some random counts
counts = matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)

# Fit model on the counts matrix
ZINB <- fitZINB(counts)
head(ZINB)
}
