% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{iterative_ordering}
\alias{iterative_ordering}
\title{iterativeOrdering}
\usage{
iterative_ordering(df, var_names, i = 1, decreasing = TRUE)
}
\arguments{
\item{df}{a \code{data.frame} object.}

\item{var_names}{character vector containing the names of one or more columns
of \code{df}.}

\item{i}{iteration index (default \code{i = 1}).}

\item{decreasing}{logical value or a vector of them. Each value should be
associated to a \code{var_name} vector's element. Should the sort order be
increasing or decreasing?}
}
\value{
the input \code{data.frame} with the \code{var_names} variables as
ordered factors.
}
\description{
Turn the chosen columns (factor) of the input \code{data.frame}
into ordered factors. For each factor, the order is given by the number of
elements in each level of that factor.
}
\examples{
# From a dataset with some factor columns
mpg <- data.frame(ggplot2::mpg)
# Order the levels of the desired factors based on the cardinality of each
# level.
ordered_mpg <- iterative_ordering(df = mpg,
   var_names = c("manufacturer", "model"),
   decreasing = c(TRUE, TRUE))
# Now the levels of the factors are ordered in a decreasing way
levels(ordered_mpg$manufacturer)
levels(ordered_mpg$model)
}
\seealso{
\code{\link{plotMutualFindings}}
}
