% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGOF.R
\name{plotRMSE}
\alias{plotRMSE}
\title{plotRMSE}
\usage{
plotRMSE(data, difference = NULL, plotIt = TRUE)
}
\arguments{
\item{data}{a list, output of the \code{\link{fitModels}} function. Each
element of the list is a `data.frame` object with \code{Model}, \code{Y}, 
\code{Y0}, \code{MD}, and \code{ZPD} columns containing the model name, the 
observed values for the mean and the zero proportion and the differences 
between observed and estimated values.}

\item{difference}{character vector, either \code{MD} or \code{ZPD} to plot
the differences between estimated and observed mean counts or the differences
between estimated zero probability and observed zero proportion.}

\item{plotIt}{logical. Should plotting be done? (default
\code{plotIt = TRUE})}
}
\value{
a \code{ggplot} object.
}
\description{
A function to plot RMSE values computed for mean difference (MD) and zero
probability difference (ZPD) values between estimated and observed values.
}
\examples{
# Generate some random counts
counts = matrix(rnbinom(n = 600, size = 3, prob = 0.5), nrow = 100, ncol = 6)

# Estimate the counts assuming several distributions
GOF <- fitModels(
    object = counts, models = c(
        "NB", "ZINB",
        "DM", "ZIG", "HURDLE"
    ), scale_HURDLE = c("median", "default")
)

# Plot the RMSE results
plotRMSE(data = GOF, difference = "MD")
plotRMSE(data = GOF, difference = "ZPD")
}
\seealso{
\code{\link{fitModels}} and \code{\link{RMSE}} for the model
estimations and the RMSE computations respectively. \code{\link{plotMD}} for
the graphical evaluation.
}
