% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOF.R
\name{prepareObserved}
\alias{prepareObserved}
\title{prepareObserved}
\usage{
prepareObserved(object, assay_name = "counts", scale = NULL)
}
\arguments{
\item{object}{a phyloseq object, a TreeSummarizedExperiment object, or a 
matrix of counts.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{scale}{If specified it refers to the character vector used in
\code{\link{fitHURDLE}} function. Either \code{median} or \code{default} to
choose between the median library size or one million as scaling factors for
raw counts.}
}
\value{
A data frame containing the continuity corrected logarithm for the
raw count mean values for each taxon of the matrix of counts in the \code{Y}
column and the observed zero rate in the \code{Y0} column. If \code{scale} is
specified the continuity corrected logarithm for the mean CPM
(\code{scale = "default"}) or the mean counts per median library size
(\code{scale = "median"}) is computed instead.
}
\description{
Continuity corrected logarithms of the average counts and fraction of zeroes
by feature.
}
\examples{
# Generate some random counts
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)

observed1 <- prepareObserved(counts)
# For the comparison with HURDLE model
observed2 <- prepareObserved(counts, scale = "median")
}
\seealso{
\code{\link{meanDifferences}}
}
