% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_basic.R
\name{set_basic}
\alias{set_basic}
\title{set_basic}
\usage{
set_basic(
  assay_name = "counts",
  pseudo_count = FALSE,
  contrast = NULL,
  test = c("t", "wilcox"),
  paired = FALSE,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{test}{name of the test to perform. Choose between "t" or "wilcox".}

\item{paired}{boolean. Choose whether the test is paired or not (default 
\code{paired = FALSE}). If \code{paired = TRUE} be sure to provide the 
object properly ordered (by the grouping variable).}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_basic}
method.
}
\description{
Set the parameters for basic differential abundance detection methods such 
as t and wilcox.
}
\examples{
# Set some basic methods
basic_methods <- set_basic(pseudo_count = FALSE, test = c("t", "wilcox"),
    contrast = c("group", "B", "A"), expand = TRUE)
}
\seealso{
\code{\link{DA_basic}}
}
