% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_linda.R
\name{set_linda}
\alias{set_linda}
\title{set_linda}
\usage{
set_linda(
  assay_name = "counts",
  formula = NULL,
  contrast = NULL,
  is.winsor = TRUE,
  outlier.pct = 0.03,
  zero.handling = c("pseudo-count", "imputation"),
  pseudo.cnt = 0.5,
  alpha = 0.05,
  p.adj.method = "BH",
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{formula}{a character string for the formula. The formula should conform to that used by \code{lm} (independent 
data) or \code{lmer} (correlated data).
 For example: \code{formula = '~x1*x2+x3+(1|id)'}. At least one fixed effect is required.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{is.winsor}{a logical value indicating whether winsorization should be performed to replace outliers (high values).
 The default is TRUE.}

\item{outlier.pct}{the expected percentage of outliers. These outliers will be winsorized. The default is 0.03.}

\item{zero.handling}{a character string of 'pseudo-count' or 'imputation' indicating the zero handling method
used when \code{feature.dat} is 'count'.  If 'pseudo-count', a\code{pseudo.cnt} will be added to each value in \code{feature.dat}. 
If 'imputation', then we use the imputation approach using the formula in the referenced paper. Basically,
zeros are imputed with values proportional to the sequencing depth. When \code{feature.dat} is 'proportion',
this parameter will be ignored and zeros will be imputed by half of the minimum for each feature.}

\item{pseudo.cnt}{a positive numeric value for the pseudo-count to be added if \code{zero.handling}
is 'pseudo-count'. Default is 0.5. }

\item{alpha}{a numerical value between 0 and 1 indicating the significance level 
for declaring differential features. Default is 0.05.}

\item{p.adj.method}{a character string indicating the p-value adjustment approach for 
addressing multiple testing. See R function \code{p.adjust}. Default is 'BH'.}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_linda}
method.
}
\description{
Set the parameters for linda differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for ANCOM with bias correction
base_linda <- set_linda(formula = "~ group", contrast = c("group", "B", "A"), 
    zero.handling = "pseudo-count", expand = TRUE)
many_linda <- set_linda(formula = "~ group", contrast = c("group", "B", "A"), 
    is.winsor = c(TRUE, FALSE), 
    zero.handling = c("pseudo-count", "imputation"), expand = TRUE)
}
\seealso{
\code{\link{DA_linda}}
}
