% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_peaks.R
\docType{methods}
\name{addGCBias}
\alias{addGCBias}
\alias{addGCBias,RangedSummarizedExperiment-method}
\alias{addGCBias,SummarizedExperiment-method}
\title{addGCBias}
\usage{
addGCBias(object, ...)

\S4method{addGCBias}{RangedSummarizedExperiment}(object,
  genome = GenomeInfoDb::genome(object))

\S4method{addGCBias}{SummarizedExperiment}(object, peaks,
  genome = GenomeInfoDb::genome(peaks))
}
\arguments{
\item{object}{(Ranged)SummarizedExperiment}

\item{...}{additional arguments}

\item{genome}{BSgenome object, by defualt hg19}

\item{peaks}{GenomicRanges with peaks, needed if object is 
SummarizedExperiment and not RangedSummarizedExperiment}
}
\value{
(Ranged)SummarizedExperiment object with new column in row metadata
with the gc content of the peak in question
}
\description{
Computes GC content for peaks
}
\section{Methods (by class)}{
\itemize{
\item \code{RangedSummarizedExperiment}: method for RangedSummarizedExperiment

\item \code{SummarizedExperiment}: method for SummarizedExperiment
}}

\examples{

data(example_counts, package = "chromVAR")
# show example on small part of data 
subset_counts <- example_counts[1:500,]
library(BSgenome.Hsapiens.UCSC.hg19)
example_counts <- addGCBias(subset_counts, 
                              genome = BSgenome.Hsapiens.UCSC.hg19)

}
