% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmers.R
\name{deviationsCovariability}
\alias{deviationsCovariability}
\title{deviationsCovariability}
\usage{
deviationsCovariability(object)
}
\arguments{
\item{object}{deviations result}
}
\value{
'covariability' matrix
}
\description{
deviationsCovariability
}
\details{
Returns the 'covariability' between motifs/kmers/peaksets. 
Covariability' is defined as covariance between Z-scores divided by variance 
of Z-scores for one motif/kmer/peakset (the row).
}
\examples{
# load very small example data
data(mini_counts, package = "chromVAR")
motifs <- getJasparMotifs()
library(motifmatchr)
motif_ix <- matchMotifs(motifs, mini_counts, 
  genome = BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19)

# computing deviations
dev <- computeDeviations(object = mini_counts, 
                         annotations = motif_ix)
                         
# get covariability for just first three motifs                         
devcov <- deviationsCovariability(dev[1:3,])                         
}
