% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{filterSamplesPlot}
\alias{filterSamplesPlot}
\title{filterSamplesPlot}
\usage{
filterSamplesPlot(object, min_in_peaks = NULL, min_depth = NULL,
  use_plotly = interactive())
}
\arguments{
\item{object}{SummarizedExperiment with matrix of fragment counts per peak 
per sample, as computed by \code{\link{getCounts}}}

\item{min_in_peaks}{minimum fraction of samples within peaks}

\item{min_depth}{minimum library size}

\item{use_plotly}{make interactive plot?}
}
\value{
indices of samples to keep
}
\description{
plot filtering of samples
}
\details{
If unspecified, min_in_peaks and min_depth cutoffs will be estimated
based on data. min_in_peaks is set to 0.5 times the median proportion of 
fragments in peaks.  min_depth is set to the maximum of 500 or 10% of the 
median library size.
}
\examples{
data(example_counts, package = "chromVAR")

counts_filtered <- filterSamples(example_counts, min_depth = 1500,
                                  min_in_peaks = 0.15, shiny = FALSE)
counts_filtered_plot <- filterSamplesPlot(counts_filtered, 
                                          min_in_peaks = 0.15,
                                          min_depth = 1500, 
                                          use_plotly = FALSE)

}
\seealso{
\code{\link{getCounts}},  \code{\link{getPeaks}}, 
\code{\link{filterPeaks}}
}
