% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variability_synergy.R
\docType{methods}
\name{getAnnotationCorrelation}
\alias{getAnnotationCorrelation}
\alias{getAnnotationCorrelation,SummarizedExperiment,SummarizedExperiment-method}
\alias{getAnnotationCorrelation,SummarizedExperiment,MatrixOrmatrix-method}
\alias{getAnnotationCorrelation,SummarizedExperiment,list-method}
\alias{getAnnotationCorrelation,MatrixOrmatrix,SummarizedExperiment-method}
\alias{getAnnotationCorrelation,MatrixOrmatrix,MatrixOrmatrix-method}
\alias{getAnnotationCorrelation,MatrixOrmatrix,list-method}
\title{getAnnotationCorrelation}
\usage{
getAnnotationCorrelation(object, annotations, ...)


  \S4method{getAnnotationCorrelation}{SummarizedExperiment,SummarizedExperiment}(object,
  annotations, background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object), variabilities = NULL)


  \S4method{getAnnotationCorrelation}{SummarizedExperiment,MatrixOrmatrix}(object,
  annotations, background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object), variabilities = NULL)

\S4method{getAnnotationCorrelation}{SummarizedExperiment,list}(object,
  annotations, background_peaks = getBackgroundPeaks(object),
  expectation = computeExpectations(object), variabilities = NULL)


  \S4method{getAnnotationCorrelation}{MatrixOrmatrix,SummarizedExperiment}(object,
  annotations, background_peaks, expectation = computeExpectations(object),
  variabilities = NULL)

\S4method{getAnnotationCorrelation}{MatrixOrmatrix,MatrixOrmatrix}(object,
  annotations, background_peaks, expectation = computeExpectations(object),
  variabilities = NULL)

\S4method{getAnnotationCorrelation}{MatrixOrmatrix,list}(object, annotations,
  background_peaks, expectation = computeExpectations(object),
  variabilities = NULL)
}
\arguments{
\item{object}{result from computeDeviations}

\item{annotations}{SummarizedExperiment of annotation matches}

\item{...}{additional arguments}

\item{background_peaks}{optional, matrix of background peaks}

\item{expectation}{optional, expected fraction of reads per peak, as computed
by computeExpectations}

\item{variabilities}{optional, variabilities computed from 
computeVariability}
}
\value{
correlation matrix
}
\description{
getAnnotationCorrelation
}
\details{
should only be run on small number of motifs/kmers/peaksets 
(very slow!)
}
\section{Methods (by class)}{
\itemize{
\item \code{object = SummarizedExperiment,annotations = SummarizedExperiment}: object and annotations are 
SummarizedExperiment

\item \code{object = SummarizedExperiment,annotations = MatrixOrmatrix}: object is SummarizedExperiment, 
annotations are Matrix

\item \code{object = SummarizedExperiment,annotations = list}: object is SummarizedExperiment, 
annotations are list

\item \code{object = MatrixOrmatrix,annotations = SummarizedExperiment}: object and annotations are 
SummarizedExperiment

\item \code{object = MatrixOrmatrix,annotations = MatrixOrmatrix}: object is SummarizedExperiment, 
annotations are Matrix

\item \code{object = MatrixOrmatrix,annotations = list}: object is SummarizedExperiment, 
annotations are list
}}

