% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_peaks.R
\docType{methods}
\name{getBackgroundPeaks}
\alias{getBackgroundPeaks}
\alias{getBackgroundPeaks,SummarizedExperiment-method}
\alias{getBackgroundPeaks,RangedSummarizedExperiment-method}
\alias{getBackgroundPeaks,MatrixOrmatrix-method}
\title{getBackgroundPeaks}
\usage{
getBackgroundPeaks(object, ...)

\S4method{getBackgroundPeaks}{SummarizedExperiment}(object,
  bias = rowData(object)$bias, niterations = 50, w = 0.1, bs = 50)

\S4method{getBackgroundPeaks}{RangedSummarizedExperiment}(object,
  bias = rowRanges(object)$bias, niterations = 50, w = 0.1, bs = 50)

\S4method{getBackgroundPeaks}{MatrixOrmatrix}(object, bias, niterations = 50,
  w = 0.1, bs = 50)
}
\arguments{
\item{object}{fragment counts as SummarizedExperiment, RangedSummarized, 
Matrix, or matrix}

\item{...}{addtional arguments}

\item{bias}{vector of values for some bias signal for each row of object}

\item{niterations}{number of background peaks to sample}

\item{w}{parameter controlling similarity of background peaks}

\item{bs}{bin size parameter}
}
\value{
matrix with one row per peak and one column per iteration.  values in
 a row represent indices of background peaks for the peak with that index
}
\description{
Function to get a set of background peaks for each peak based on GC content 
and # of fragments across all samples
}
\details{
Background peaks are chosen by sampling peaks based on similarity in
GC content and # of fragments across samples using the Mahalanobis distance.
The w paramter controls how similar background peaks should be. The bs 
parameter controls the precision with which the similarity is computed;
increasing bs will make the function run slower. Sensible default parameters 
are chosen for both.
}
\section{Methods (by class)}{
\itemize{
\item \code{SummarizedExperiment}: method for SummarizedExperiment

\item \code{RangedSummarizedExperiment}: method for RangedSummarizedExperiment

\item \code{MatrixOrmatrix}: method for Matrix or matrix
}}

\examples{

# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")

# get background peaks
bgpeaks <- getBackgroundPeaks(mini_counts)

}
