% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cis.R
\docType{methods}
\name{getCisGroups}
\alias{getCisGroups}
\alias{getCisGroups,RangedSummarizedExperiment-method}
\alias{getCisGroups,GenomicRanges-method}
\title{getCisGroups}
\usage{
getCisGroups(object, ...)

\S4method{getCisGroups}{RangedSummarizedExperiment}(object, grpsize = 25,
  stepsize = 10)

\S4method{getCisGroups}{GenomicRanges}(object, grpsize = 25, stepsize = 10)
}
\arguments{
\item{object}{GenomicRanges or RangedSummarizedExperiment}

\item{...}{additional arguments}

\item{grpsize}{number of peaks to include in each grouop}

\item{stepsize}{number of peaks between each new set of groups}
}
\value{
SummarizedExperiment with annotationMatches assay storing which peaks
belong to which groups
}
\description{
Function for grouping peaks based on proximity along chromosomes
}
\section{Methods (by class)}{
\itemize{
\item \code{RangedSummarizedExperiment}: method for RangedSummarizedExperiment

\item \code{GenomicRanges}: method for GenomicRanges
}}

\examples{

# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")
mini_counts <- sort(mini_counts)
cisg <- getCisGroups(mini_counts)
}
\author{
Alicia Schep
}
