% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inputs.R
\name{getCounts}
\alias{getCounts}
\title{getCounts}
\usage{
getCounts(alignment_files, peaks, paired, by_rg = FALSE, format = c("bam",
  "bed"), colData = NULL)
}
\arguments{
\item{alignment_files}{filenames for bam or bed files with aligned reads}

\item{peaks}{GRanges object with peaks}

\item{paired}{paired end data?}

\item{by_rg}{use RG tags in bam to separate groups?}

\item{format}{bam or bed?  default is bam}

\item{colData}{sample annotation DataFrame}
}
\value{
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment-class}}
 object
}
\description{
makes matrix of fragment counts in peaks using one or multiple bam or bed 
files
}
\examples{

# First we'll read in some peaks
peaks_file <- system.file("extdata", "test_bed.txt", package = "chromVAR")
test_peaks <- getPeaks(peaks_file, sort = TRUE)

# With single bam with RG tags (can also give multiple bams with RG)
test_rg <- system.file("extdata", "test_RG.bam", package = "chromVAR")
test_counts <- getCounts(test_rg, peaks = test_peaks, by_rg = TRUE, 
                          paired = TRUE, 
                          colData = S4Vectors::DataFrame(condition ="A"))
                          

# Multiple bams without RG tags
test_bam1 <- system.file("extdata", "test_single1.bam", package = "chromVAR")
test_bam2 <- system.file("extdata", "test_single2.bam", package = "chromVAR")
test_bam3 <- system.file("extdata", "test_single3.bam", package = "chromVAR")
test_counts2 <- getCounts(c(test_bam1, test_bam2,test_bam3), 
                           peaks = test_peaks, by_rg = FALSE, 
                           paired = TRUE, 
                           colData = S4Vectors::DataFrame(celltype = 
                                                          c("A","B","C"))) 
                           
# Bed file with reads (can give multiple bed files, here we will just read 1)
test_bed <- system.file("extdata", "test_reads.bed", package = "chromVAR")
test_counts3 <- getCounts(test_bed, test_peaks, by_rg = FALSE, 
                           paired = FALSE, 
                           format = "bed")                           
}
\seealso{
\code{\link{getSampleDepths}},  \code{\link{getPeaks}}, 
\code{\link{filterSamples}}
}
