% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{getSampleCorrelation}
\alias{getSampleCorrelation}
\title{getSampleCorrelation}
\usage{
getSampleCorrelation(object, threshold = 1.5)
}
\arguments{
\item{object}{deviations result}

\item{threshold}{threshold for variability}
}
\value{
correlation matrix between samples
}
\description{
Get correlation between samples based on bias corrected deviations
}
\details{
This function will compute the correlation between samples based on 
the normalized deviations. It will first remove correlated motifs/peak sets. 
Then the pearson correlation coefficient will be computed and returned.
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
sample_cor <- getSampleCorrelation(mini_dev, threshold = 0.8)  
# setting very low variabilitiy threshold because this is mini data set
# threshold should generally be above 1
# Use plotVariability to get a sense of an appropriate threshold
# As this is mini data set, results probably not meaningful!
}
\seealso{
\code{\link{getSampleDistance}}
}
\author{
Alicia Schep
}
