% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{getSampleDistance}
\alias{getSampleDistance}
\title{getSampleDistance}
\usage{
getSampleDistance(object, threshold = 1.5, initial_dims = 50,
  distance_function = dist)
}
\arguments{
\item{object}{deviations result}

\item{threshold}{threshold for variability}

\item{initial_dims}{initial dimentions for preliminary dimensionality 
reduction via pca}

\item{distance_function}{distance function to use}
}
\value{
dist object for distance between samples
}
\description{
Get distance between samples based on bias corrected deviations
}
\details{
This function will compute the distance between samples based on the
 normalized deviations.  It will first remove correlated motifs / peak sets. 
Then the dimensionality will be further reduced via PCA if the number of 
dimensions exceeds initial_dims.  Then  the supplied distance_function will 
be used.
}
\examples{
# Load very small example results from computeDeviations
data(mini_dev, package = "chromVAR")
sample_dist <- getSampleDistance(mini_dev, threshold = 0.8)  
# setting very low variabilitiy threshold because this is mini data set
# threshold should generally be above 1
# Use plotVariability to get a sense of an appropriate threshold
# As this is mini data set, results  not meaningful!
}
\seealso{
\code{\link{getSampleCorrelation}}
}
\author{
Alicia Schep
}
