% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_sets.R
\docType{methods}
\name{makePermutedSets}
\alias{makePermutedSets}
\alias{makePermutedSets,SummarizedExperiment,SummarizedExperiment-method}
\alias{makePermutedSets,RangedSummarizedExperiment,SummarizedExperiment-method}
\alias{makePermutedSets,MatrixOrmatrix,SummarizedExperiment-method}
\alias{makePermutedSets,SummarizedExperiment,MatrixOrmatrix-method}
\alias{makePermutedSets,RangedSummarizedExperiment,MatrixOrmatrix-method}
\alias{makePermutedSets,MatrixOrmatrix,MatrixOrmatrix-method}
\alias{makePermutedSets,SummarizedExperiment,list-method}
\alias{makePermutedSets,RangedSummarizedExperiment,list-method}
\alias{makePermutedSets,MatrixOrmatrix,list-method}
\title{makePermutedSets}
\usage{
makePermutedSets(object, annotations, ...)

\S4method{makePermutedSets}{SummarizedExperiment,SummarizedExperiment}(object,
  annotations, bias = rowData(object)$bias, window = 10)


  \S4method{makePermutedSets}{RangedSummarizedExperiment,SummarizedExperiment}(object,
  annotations, bias = rowRanges(object)$bias, window = 10)

\S4method{makePermutedSets}{MatrixOrmatrix,SummarizedExperiment}(object,
  annotations, bias, window = 10)

\S4method{makePermutedSets}{SummarizedExperiment,MatrixOrmatrix}(object,
  annotations, bias = rowData(object)$bias, window = 10)

\S4method{makePermutedSets}{RangedSummarizedExperiment,MatrixOrmatrix}(object,
  annotations, bias = rowRanges(object)$bias, window = 10)

\S4method{makePermutedSets}{MatrixOrmatrix,MatrixOrmatrix}(object, annotations,
  bias, window = 10)

\S4method{makePermutedSets}{SummarizedExperiment,list}(object, annotations,
  bias = rowData(object)$bias, window = 10)

\S4method{makePermutedSets}{RangedSummarizedExperiment,list}(object,
  annotations, bias = rowRanges(object)$bias, window = 10)

\S4method{makePermutedSets}{MatrixOrmatrix,list}(object, annotations, bias,
  window = 10)
}
\arguments{
\item{object}{fragment counts stored as RangedSummarizedExperiment, 
SummarizedExperiment, matrix, or Matrix}

\item{annotations}{annotations as SummarizedExperiment, matrix, or list}

\item{...}{additional arguments}

\item{bias}{vector of some bias signal (usually gc content) for each row of 
object}

\item{window}{number of nearest neighbors to consider}
}
\value{
SummarizedExperiment storing bias bins annotation
}
\description{
Makes annotations sets with similar bias to input sets
}
\details{
Will create nbins * 3 annotations based on sampling from peaks with 
a certain fragment count, fragment count, or fragment count & bias.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = SummarizedExperiment,annotations = SummarizedExperiment}: method for SummarizedExperiment and 
SummarizedExperiment

\item \code{object = RangedSummarizedExperiment,annotations = SummarizedExperiment}: method for RangedSummarizedExperiment and 
SummarizedExperiment

\item \code{object = MatrixOrmatrix,annotations = SummarizedExperiment}: method for Matrix or matrix and 
SummarizedExperiment

\item \code{object = SummarizedExperiment,annotations = MatrixOrmatrix}: method for SummarizedExperiment and 
MatrixOrmatrix

\item \code{object = RangedSummarizedExperiment,annotations = MatrixOrmatrix}: method for RangedSummarizedExperiment and 
MatrixOrmatrix

\item \code{object = MatrixOrmatrix,annotations = MatrixOrmatrix}: method for Matrix/matrix and Matrix/matrix

\item \code{object = SummarizedExperiment,annotations = list}: method for SummarizedExperiment and list

\item \code{object = RangedSummarizedExperiment,annotations = list}: method for RangedSummarizedExperiment and list

\item \code{object = MatrixOrmatrix,annotations = list}: method for Matrix or matrix and list
}}

\examples{
# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")
data(example_motifs, package = "motifmatchr")
library(motifmatchr)
library(BSgenome.Hsapiens.UCSC.hg19)
motif_ix <- matchMotifs(example_motifs, mini_counts, 
                         genome = BSgenome.Hsapiens.UCSC.hg19)

perm_sets <- makePermutedSets(mini_counts, motif_ix)
}
\author{
Alicia Schep
}
