% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/concordex.R
\docType{methods}
\name{calculateConcordex}
\alias{calculateConcordex}
\alias{runConcordex}
\alias{calculateConcordex,ANY-method}
\alias{calculateConcordex,SummarizedExperiment-method}
\alias{calculateConcordex,SingleCellExperiment-method}
\alias{calculateConcordex,SpatialExperiment-method}
\alias{runConcordex,SpatialExperiment-method}
\alias{runConcordex,SingleCellExperiment-method}
\title{Identify Spatially Homogeneous Regions with concordex}
\usage{
calculateConcordex(x, ...)

runConcordex(x, ...)

\S4method{calculateConcordex}{ANY}(
  x,
  labels,
  ...,
  n_neighbors = 30,
  compute_similarity = FALSE,
  BLUSPARAM,
  BNINDEX,
  BNPARAM = KmknnParam(),
  BPPARAM = SerialParam()
)

\S4method{calculateConcordex}{SummarizedExperiment}(x, labels, ..., assay.type = "logcounts")

\S4method{calculateConcordex}{SingleCellExperiment}(x, labels, ..., use.dimred = NULL)

\S4method{calculateConcordex}{SpatialExperiment}(x, labels, ..., use.spatial = TRUE)

\S4method{runConcordex}{SpatialExperiment}(x, labels, ..., name = "NBC")

\S4method{runConcordex}{SingleCellExperiment}(x, labels, ..., name = "NBC")
}
\arguments{
\item{x}{A \code{\link{SpatialExperiment}},
\code{SpatialFeatureExperiment},
\code{\link{SingleCellExperiment}}, or \code{\link{SummarizedExperiment}}
object containing a count matrix.

Otherwise, a numeric matrix-like object containing counts for observations
(e.g. cells/spots) on the rows and features on the columns.}

\item{...}{Other parameters passed to default method}

\item{labels}{Observation labels used to compute the neighborhood consolidation
matrix. Continuous or discrete labels are allowed, and typically, integer
labels are assumed to be discrete.

Labels can be specified as follows:
\itemize{
\item A vector or matrix-like object with one entry per observation If a matrix, the
observations should be on the rows and the label identifiers on the columns.
\item If \code{x} inherits from \code{\link{SummarizedExperiment-class}}, a
string or character vector specifying the names of columns in \code{colData(x)}
or the name of a dimensionality reduction result (see \link{reducedDimNames})
}}

\item{n_neighbors}{Number of neighbors to expect for each observation.
Defaults to 30.}

\item{compute_similarity}{Logical. Whether to return the label similarity matrix.
Only useful if discrete labels are provided.}

\item{BLUSPARAM}{A \code{\link{BlusterParam-class}} object specifying the clustering
algorithm to use to identify spatial homogeneous regions. If this parameter
is not specified, then regions are not returned. By default, this parameter
is missing.}

\item{BNINDEX}{A \code{\link{BiocNeighborIndex}} object containing the precomputed
index information, see \link{findKNN}.}

\item{BNPARAM}{A \code{\link{BiocNeighborParam}} object specifying the algorithm to use.
This can be missing if \code{BNINDEX} is supplied, see \link{findKNN}.}

\item{BPPARAM}{A \code{\link{BiocParallelParam}} object specifying whether
and how computing the metric for numerous observations shall be
parallelized (see \code{\link{bpparam}}).}

\item{assay.type}{String or integer scalar indicating the assay of \code{x}
containing the counts.}

\item{use.dimred}{Integer or string specifying the reduced dimensions to use
for construction of the k-nearest neighbor graph. Note that if this is not
\code{NULL}, reduced dimensions can not be used as labels to compute the
neighborhood consolidation matrix.}

\item{use.spatial}{Logical, should the spatial coordinates be used to compute the
k-nearest neighbor graph?}

\item{name}{String specifying the name to be used to store the result in the
\code{\link{reducedDims}} of the output.}
}
\value{
A sparse matrix
}
\description{
Compute the neighborhood consolidation matrix and identify spatial
homogeneous regions.
}
\examples{
example(read10xVisium, "SpatialExperiment")
library(bluster)

## Setting BLUSPARAM clusters the consolidation
## matrix into SHRs
cdx <- calculateConcordex(
  spe, "in_tissue",
  n_neighbors=10,
  BLUSPARAM=KmeansParam(3)
)

## SHRs are an attribute of the result
shr <- attr(cdx, "shr")

## The label similarity matrix can be computed
## with `compute_similarity=TRUE`
cdx <- calculateConcordex(
  spe, "in_tissue",
  n_neighbors=10,
  compute_similarity=TRUE,
  BLUSPARAM=KmeansParam(3)
)


}
