#' @rdname example_bin_se
#' @name example_bin_se
#' @aliases example_bin_se
#'
#' @title Example bin-level `RangedSummarizedExperiment`
#'
#' @description
#' An object produced by \code{\link{countFeatures}} containing small subset of
#'  genes from mouse hippocampal slices undergoing Forskolin-induced long-term
#' potentiation (GSE84643).
#'
#' @return a `RangedSummarizedExperiment`
#' @references \url{https://www.nature.com/articles/s41598-017-17407-w}
NULL

#' @rdname example_gene_annotation
#' @name example_gene_annotation
#' @aliases example_gene_annotation
#'
#' @title Example gene annotation
#'
#' @description
#' An example gene annotation containing only a small subset of mouse genes.
#'
#' @return a `GRanges` object
NULL

#' @rdname rn6_PAS
#' @name rn6_PAS
#' @aliases rn6_PAS
#'
#' @title Poly-A sites compendium for Rattus Norvegicus (Rno6)
#'
#' @description
#' These are the sites from polyA_DB release 3.2, downloaded from
#' \url{https://exon.apps.wistar.org/PolyA_DB/v3/download/3.2/rat_pas.zip},
#' and lifted over to Rno6.
#'
#' @return a `GRanges` object
NULL
