% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEU_wrappers.R
\name{diffSpliceDGEWrapper}
\alias{diffSpliceDGEWrapper}
\alias{DEUwrappers}
\alias{diffSpliceWrapper}
\alias{DEXSeqWrapper}
\title{DEUwrappers}
\usage{
diffSpliceDGEWrapper(
  se,
  design,
  coef = NULL,
  QLF = TRUE,
  robust = TRUE,
  countFilter = TRUE,
  excludeTypes = NULL
)

diffSpliceWrapper(
  se,
  design,
  coef = NULL,
  robust = TRUE,
  improved = TRUE,
  countFilter = TRUE,
  excludeTypes = NULL
)

DEXSeqWrapper(
  se,
  design = ~sample + exon + condition:exon,
  reducedModel = ~sample + exon,
  excludeTypes = NULL,
  ...
)
}
\arguments{
\item{se}{A bin-wise SummarizedExperiment as produced by
\code{\link{countFeatures}}}

\item{design}{A formula (using columns of `colData(se)`) or (for
`diffSpliceWrapper` or `diffSpliceDGEWrapper` only) a model.matrix.}

\item{coef}{The coefficient to be tested (ignored for `DEXSeqWrapper`).}

\item{QLF}{Logical; whether to use edgeR's quasi-likelihood negative
binomial (applicable only to `diffSpliceDGEWrapper`).}

\item{robust}{Logical; whether to use robust fitting for the dispersion
trend (ignored for `DEXSeqWrapper`).}

\item{countFilter}{Logical; whether to filter out low-count bins (ignored
for `DEXSeqWrapper`).}

\item{excludeTypes}{A vector of bin types to ignore for testing. To test
for any kind of differential usage, leave empty. To test for differential
UTR usage, use `excludeTypes=c("CDS","non-coding")` (or see
 \code{\link{geneLevelStats}} for more options).}

\item{improved}{Logical; whether to use \code{\link{diffSplice2}} instead
of the original \code{\link[limma]{diffSplice}} (default TRUE).}

\item{reducedModel}{A reduced formula (applicable only to `DEXSeqWrapper`).}

\item{...}{Further arguments (passed to `testForDEU` and
`estimateExonFoldChanges`) of `DEXSeq`. Can for instance be used to enable 
multithreading, by passing `BPPARAM=BiocParallel::MulticoreParam(ncores)`.}
}
\value{
The `se` object with additional rowData columns contain bin (i.e.
exon) -level statistics, and a metadata slot containing gene level p-values.
}
\description{
Wrappers around commonly-used DEU methods
(\code{\link[edgeR]{diffSpliceDGE}}, \code{\link[DEXSeq]{DEXSeq}} and an
improved version of \code{\link[limma]{diffSplice}}
}
\examples{
library(SummarizedExperiment)
data(example_bin_se)
se <- diffSpliceWrapper(example_bin_se, ~condition)
head(rowData(se))
}
